const menuItemRoutes = require('express').Router();
const menuItemsController = require('../controllers/menuItems.controller');

module.exports = (app) => {
    // Create a new menu group
    menuItemRoutes.post('/', menuItemsController.create);

    // get all the menu groups

    menuItemRoutes.get('/', menuItemsController.findAll);

    // get all menu with sub menu

    menuItemRoutes.get('/main-menu/:group_id', menuItemsController.getMenuWithSubMenu);

    //  update menu groups

    menuItemRoutes.put('/:id', menuItemsController.update);

    // delete single menu group with id

    menuItemRoutes.delete('/:id', menuItemsController.delete);

    app.use('/api/menu-items', menuItemRoutes);
};
