module.exports = (app) => {
  const productUnitRouter = require("express").Router();
  const productUnitController = require("../controllers/productUnit.controller");

  // Create a new Post
  productUnitRouter.post("/", productUnitController.create);
  // Retrieve all Posts
  productUnitRouter.get("/", productUnitController.findAll);
  // Retrieve a single Post with id
  productUnitRouter.get("/:id", productUnitController.findOne);
  // Update a Post with id
  productUnitRouter.put("/:id", productUnitController.update);
  // Delete a Post with id
  productUnitRouter.delete("/:id", productUnitController.delete);
  // Delete all Posts
  productUnitRouter.delete("/", productUnitController.deleteAll);

  app.use("/api/product-unit", productUnitRouter);
};
