const db = require("../../../config/database.config");
const SystemSetting = db.model.systemSetting;
const errorResponse = require("../../../utils/errorResponse");
const successResponse = require("../../../utils/successResponse");
path = require("path");

// update system settings by default row id 1
exports.update = async (req, res) => {
  try {
    const {
      website_name,
      website_url,
      tag_line,
      short_name,
      address,
      mobile,
      email,
      vat_type,
      currency,
      copyright,
      // year,
      // days_of_week,
      // point,
      // introducer_label,
      // reg_prefix,
      // reset_sequence_in_month,
      // month,
      // starting_digit,
      // package_in_medical_form,
    } = req.body;
    const { files } = req;

    // check if data exists or not
    const isExists = SystemSetting.findOne({ where: { id: 1 } });

    const data = {
      website_name,
      website_url,
      tag_line,
      short_name,
      address,
      mobile,
      email,
      vat_type,
      currency,
      copyright,
      // year,
      // days_of_week,
      // point,
      // introducer_label,
      // reg_prefix,
      // reset_sequence_in_month,
      // month,
      // starting_digit,
      // package_in_medical_form,
      // header_image:
      //   files?.find((file) => file.fieldname === "header_image")?.filename ||
      //   isExists?.header_image,
      // footer_image:
      //   files?.find((file) => file.fieldname === "footer_image")?.filename ||
      //   isExists?.footer_image,
      // background_image:
      //   files?.find((file) => file.fieldname === "background_image")
      //     ?.filename || isExists?.background_image,
      logo_image:
        files?.find((file) => file.fieldname === "logo_image")?.filename ||
        isExists?.logo_image,
      fav_image:
        files?.find((file) => file.fieldname === "fav_image")?.filename ||
        isExists?.fav_image,
    };

    if (!isExists) {
      return await SystemSetting.create(data);
    }

    const result = await SystemSetting.update(data, {
      where: { id: 1 },
    });

    if (!result?.includes(1)) {
      return errorResponse(
        500,
        "ERROR",
        "Failed to update system settings",
        res
      );
    }
    return successResponse(200, "OK", "Update Successfully", res);
  } catch (error) {
    return errorResponse(
      500,
      "ERROR",
      error.message || "Failed to Register, Please try Again!",
      res
    );
  }
};

exports.getData = (req, res) => {
  SystemSetting.findAll()
    .then((data) => {
      successResponse(200, "OK", data, res);
    })
    .catch((err) => {
      errorResponse(
        500,
        "ERROR",
        err.message || "Some error occurred while fetching the data",
        res
      );
    });
};

exports.getDataById = (req, res) => {
  SystemSetting.findOne({ where: { id: req.params.id } })
    .then((data) => {
      if (!data) {
        return errorResponse(404, "ERROR", "Data not found", res);
      }
      successResponse(200, "OK", data, res);
    })
    .catch((err) => {
      errorResponse(500, "ERROR", err.message || "Some error occurred", res);
    });
};

exports.upload = async (req, res) => {
  try {
    const files = req.files;

    const systemSettingData = await SystemSetting.findOne({
      where: { id: 1 },
    });

    if (Array.isArray(files) && files?.length > 0) {
      let logoUrl, favUrl, headerUrl, footerUrl, backgroundUrl;

      // Iterate over the files and assign URLs based on fieldname
      files.forEach((file) => {
        if (file.fieldname === "logo_image") {
          logoUrl = file.filename;
        } else if (file.fieldname === "fav_icon") {
          favUrl = file.filename;
        } else if (file.fieldname === "header_image") {
          headerUrl = file.filename;
        } else if (file.fieldname === "footer_image") {
          footerUrl = file.filename;
        } else if (file.fieldname === "background_image") {
          backgroundUrl = file.filename;
        }
      });

      if (systemSettingData) {
        const data = {};

        if (logoUrl) data.logo_image = logoUrl;
        if (favUrl) data.fav_image = favUrl;
        if (headerUrl) data.header_image = headerUrl;
        if (footerUrl) data.footer_image = footerUrl;
        if (backgroundUrl) data.background_image = backgroundUrl;

        await SystemSetting.update(data, {
          where: { id: 1 },
        });

        return res.send(data); // Return the updated data
      } else {
        return res.json({ msg: "No data found" });
      }
    } else {
      return res.json({ msg: "No files uploaded" });
    }
  } catch (error) {
    console.log(error);
    return res.status(500).send({ error: "Internal Server Error" });
  }
};
