// const { Op } = require('sequelize');

const fs = require('fs');

const db = require('../../../../config/database.config');
const base64Encode = require('../../../../utils/base64Encode');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const AudioSurahModel = db.model.audioSurah;

const audioFilePath = `${__dirname}/../../../../uploads/website/audio/`;
// const a = require('../../../../uploads/website/audio')

exports.create = async (req, res) => {
    try {
        const { surah_name, para_no, order, status, description, reciter_name } = req.body;
        console.log('surah', req.body);

        const audio_file = req.files?.find((file) => file?.fieldname === 'audio_file')?.filename;

        const audioSurah = {
            surah_name,
            para_no,
            audio_file,
            order,
            status,
            description,
            reciter_name,
        };
        const result = await AudioSurahModel.create(audioSurah);

        if (!result) {
            return errorResponse(404, 'FAILED', 'event category created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await AudioSurahModel.findAll({
            order: [['order', 'ASC']],
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getAllActive = async (req, res) => {
    try {
        let { page = 1, limit = 10 } = req.query;

        page = parseInt(page, 10);
        limit = parseInt(limit, 10);

        const offset = (page - 1) * limit;

        const result = await AudioSurahModel.findAll({
            order: [['order', 'ASC']],
            offset,
            limit,
            // where: {
            //     status: 1,
            // },
        });

        const resultWithAudio = await Promise.all(
            result.map(async (audioSurah) => ({
                ...audioSurah.dataValues,
                audio_file: base64Encode(
                    fs.readFileSync(audioFilePath + audioSurah.dataValues.audio_file)
                ),
            }))
        );

        return successResponse(200, 'OK', resultWithAudio, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await AudioSurahModel.findOne({
            where: {
                id,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// find all the media gallery by audioSurah id

exports.getActiveDataById = async (req, res) => {
    try {
        console.log(req);
        const { id } = req.params;
        console.log(id);
        const result = await AudioSurahModel.findOne({
            where: {
                status: 1,
                id,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { surah_name, para_no, description, reciter_name, order, status } = req.body;

        const audio_file = req.files?.find((file) => file?.fieldname === 'audio_file')?.filename;

        const isExist = await AudioSurahModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const audioSurah = {
            surah_name,
            para_no,
            audio_file: audio_file || isExist.audio_file,
            description,
            order,
            status,
            reciter_name,
        };

        const result = await AudioSurahModel.update(audioSurah, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'audioSurah Data created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await AudioSurahModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'audioSurah  deleted failed', res);
        }

        return successResponse(204, 'OK', 'audioSurah deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
