const bannerRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const bannerController = require('../controller/banner.controller');

module.exports = (app) => {
    bannerRouter.post('/', websiteImageUpload, bannerController.create);

    // get all

    bannerRouter.get('/', bannerController.getAll);

    // get active data

    bannerRouter.get('/active', bannerController.getActiveData);

    // update

    bannerRouter.put('/:id', websiteImageUpload, bannerController.update);

    // delete

    bannerRouter.delete('/:id', bannerController.delete);

    app.use('/api/banner', bannerRouter);
};
