const campeignRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const campeignController = require('../controllers/campeign.controller');
const getActiveData = require('../controllers/getActiveData');
const getAllcampeignsByCatId = require('../controllers/getAllCampeignDataByCatId');

module.exports = (app) => {
    campeignRouter.post('/', websiteImageUpload, campeignController.create);

    // get all

    campeignRouter.get('/', campeignController.getAll);

    // get one campeign with id

    campeignRouter.get('/:id', campeignController.getOne);

    // get active data

    campeignRouter.get('/get-campeigns/active', getActiveData.getActiveData);

    // get campeign data by category

    campeignRouter.get('/active/category/:cat_id', getAllcampeignsByCatId.getAllCampeignsByCatId);

    // update

    campeignRouter.put('/:id', websiteImageUpload, campeignController.update);

    // delete

    campeignRouter.delete('/:id', campeignController.delete);

    app.use('/api/campeigns', campeignRouter);
};
