const eventCatRouter = require("express").Router();
const eventCatController = require("../controllers/eventCat.controller");

module.exports = (app) => {
  eventCatRouter.post("/", eventCatController.create);

  // get all

  eventCatRouter.get("/", eventCatController.getAll);

  // get one event with id

  eventCatRouter.get("/:id", eventCatController.getOne);

  // get active data

  eventCatRouter.get("/getData/active", eventCatController.getActiveData);

  // update

  eventCatRouter.put("/:id", eventCatController.update);

  // delete

  eventCatRouter.delete("/:id", eventCatController.delete);

  app.use("/api/event-category", eventCatRouter);
};
