const db = require('../../../../config/database.config');

const Package = db.model.package;
const PackageFeature = db.model.packageFeature;
const MonthModel = db.model.month;
const PackageMonthModel = db.model.packageMonth;
const PackageIncludedModel = db.model.packageIncluded;
const PackageExcludedModel = db.model.packageExcluded;
const PackageItineraryModel = db.model.packageItinerary;
const PackagePointsModel = db.model.packagePoints;
const PackageFacilitiesModel = db.model.PackageFacilities;
const FacilityModel = db.model.facility;
// const { PackageCategory } = db.model;
const { travelCategory, tourType, destination } = db.model;
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

// Accociated models
const models = [
    PackageMonthModel,
    PackageIncludedModel,
    PackageExcludedModel,
    PackageItineraryModel,
    PackagePointsModel,
    PackageFacilitiesModel
];

const bulkDeleteItems = async (model, packageId) => {
    try {
        const deletedCount = await model.destroy({
            where: {
                package_id: packageId,
            },
        });
        console.log(`Deleted rows from ${model?.name}:`, deletedCount);
    } catch (error) {
        console.error(`Error deleting rows from ${model?.name}:`, error.message);
        throw new Error(`Failed to delete items from ${model?.name}`);
    }
};

/**
 * Bulk delete items by id by passing the id and the models array
 * @param {int} id 
 * @param {array} modelsArray 
 */
async function bulkDeleteItemsById(id, modelsArray) {
    try {
        for (const model of modelsArray) {
            await bulkDeleteItems(model, id);
            console.log(`All ${model} deleted of ${id} successfully`);
        }
        console.log(`All items deleted successfully.`);
    } catch (error) {
        console.error(`Error deleting items:`, error);
    }
}

// Example usage


const bulkCreateMonths = async (data, model, packageId) => {
    const parsedData = JSON.parse(data || '[]');
    if (parsedData.length > 0) {
        const items = parsedData.map((item) => ({
            package_id: packageId,
            month_id: item.value,
        }));
        console.log(`packageSub parsedData ----->`, parsedData)
        const packageSub = await model.bulkCreate(items);
        console.log(`packageSub  ----->`, packageSub)
    }
};

// const bulkCreateMonths = async (data, model, packageId) => {
//     const parsedData = JSON.parse(data || '[]');
//     if (parsedData.length > 0) {
//         // First validate that all month_ids exist in the MonthModel
//         const monthIds = parsedData.map(item => item.value);
//         const existingMonths = await MonthModel.findAll({
//             where: {
//                 id: monthIds
//             }
//         });

//         if (existingMonths.length !== monthIds.length) {
//             throw new Error('One or more invalid month IDs provided');
//         }

//         const items = parsedData.map((item) => ({
//             package_id: packageId,
//             month_id: item.value,
//         }));
//         console.log(`packageSub parsedData ----->`, parsedData)
//         const packageSub = await model.bulkCreate(items);
//         console.log(`packageSub  ----->`, packageSub)
//     }
// };

// Helper function to handle bulk creation
const bulkCreateItems = async (data, model, packageId) => {
    const parsedData = JSON.parse(data || '[]');
    if (parsedData.length > 0) {
        const items = parsedData.map((item) => ({
            package_id: packageId,
            value: item?.value,
        }));
        console.log(`packageSub parsedData ----->`, parsedData)
        const packageSub = await model.bulkCreate(items);
        console.log(`packageSub  ----->`, packageSub)
    }
};

// Helper function to handle bulk creation
const bulkCreateItineraryItems = async (data, model, packageId) => {
    const parsedData = JSON.parse(data || '[]');
    if (parsedData.length > 0) {
        const items = parsedData.map((item) => ({
            package_id: packageId,
            day: item?.day,
            title: item?.title,
            value: item?.value,
        }));
        console.log(`packageSub parsedData ----->`, parsedData)
        const packageSub = await model.bulkCreate(items);
        console.log(`packageSub  ----->`, packageSub)
    }
};

exports.create = async (req, res) => {
    try {
        const packageData = req.body;
        console.log('packageData req.body=>>>', packageData);

        const {
            name,
            price,
            package_discount,
            duration,
            tour_month,
            travelCategoryId,
            tourTypeId,
            destination_id,
            min_age,
            description,
            facility,
            included, // json 
            excluded,
            itinerary,
            highlights_description,
            highlights_bulletpoints,
            featured,
            popular,
            status,
        } = packageData;
        //   res.json(packageData);
        console.log('packageData =>', packageData);

        const { files } = req;
        const image = files?.find((file) => file?.fieldname === 'image').filename;

        console.log('files =>', files);
        console.log('image =>', image);

        const newPackage = await Package.create({
            name,
            image,
            price,
            package_discount,
            duration,
            // tour_month,
            travelCategoryId,
            tourTypeId,
            destination_id,
            min_age,
            description,
            // facility,
            highlights_description,
            highlights_bulletpoints,
            // included,
            // excluded,
            // itinerary,
            featured,
            popular,
            status,
        });

        if (!newPackage) {
            return errorResponse(500, 'ERROR', 'Package not created', res);
        }

        console.log("newPackage ===>", newPackage);

        const { id } = newPackage;



        // const bulkCreateMonths = async (data, model, packageId) => {
        //     const parsedData = JSON.parse(data || '[]');
        //     if (parsedData.length > 0) {
        //         const items = parsedData.map((item) => ({
        //             package_id: packageId,
        //             month_id: item.value,
        //         }));
        //         console.log(`packageSub parsedData ----->`, parsedData)
        //         const packageSub = await model.bulkCreate(items);
        //         console.log(`packageSub  ----->`, packageSub)
        //     }
        // };

        // await Handle`included`, `excluded`, `itinerary`, and`highlights_bulletpoints`
        await bulkCreateMonths(tour_month, PackageMonthModel, id),
            await bulkCreateItems(included, PackageIncludedModel, id),
            await bulkCreateItems(excluded, PackageExcludedModel, id),
            await bulkCreateItems(highlights_bulletpoints, PackagePointsModel, id),
            await bulkCreateItineraryItems(itinerary, PackageItineraryModel, id),
            await bulkCreateItems(facility, PackageFacilitiesModel, id),


            // await Promise.all([
            // bulkCreateItems(included, PackageIncluded, id),
            // bulkCreateItems(excluded, PackageExcluded, id),
            // bulkCreateItineraryItems(itinerary, PackageItinerary, id),
            // bulkCreateItems(highlights_bulletpoints, PackagePoints, id),
            // ]);

            // // Handle `included` field
            // const parsedIncluded = JSON.parse(included || '[]');
            // if (parsedIncluded.length > 0) {
            //     await Promise.all(
            //         parsedIncluded.map(async (item) => {
            //             await PackageIncluded.create({
            //                 package_id: id,
            //                 value: item.value,
            //             });
            //         })
            //     );
            // }

            // // Handle `excluded` field
            // const parsedExcluded = JSON.parse(excluded || '[]');
            // if (parsedExcluded.length > 0) {
            //     await Promise.all(
            //         parsedExcluded.map(async (item) => {
            //             await PackageExcluded.create({
            //                 package_id: id,
            //                 value: item.value,
            //             });
            //         })
            //     );
            // }

            // // Handle `itinerary` field
            // const parsedItinerary = JSON.parse(itinerary || '[]');
            // if (parsedItinerary.length > 0) {
            //     await Promise.all(
            //         parsedItinerary.map(async (item) => {
            //             await PackageItinerary.create({
            //                 package_id: id,
            //                 // day: item.day, // Assuming itinerary has a `day` field
            //                 value: item.value, // Assuming itinerary has a `description` field
            //             });
            //         })
            //     );
            // }

            // // Handle `highlights_bulletpoints` field
            // const parsedHighlights = JSON.parse(highlights_bulletpoints || '[]');
            // if (parsedHighlights.length > 0) {
            //     await Promise.all(
            //         parsedHighlights.map(async (item) => {
            //             await PackagePoints.create({
            //                 package_id: id,
            //                 value: item.value,
            //             });
            //         })
            //     );
            // }
            // Handle `features` field
            // const { id } = newPackage;
            // if (features.length > 0) {
            //     await Promise.all(
            //         features.map(async (feature) => {
            //             await PackageFeature.create({
            //                 package_id: id,
            //                 name: feature.name,
            //                 value: feature.value,
            //             });
            //         })
            //     );
            // }
            successResponse(200, 'OK', newPackage, res);
    } catch (err) {
        console.log("Erro P", err);
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.getAll = async (req, res) => {
    try {
        const packages = await Package.findAll({
            include: [
                {
                    model: travelCategory,
                    as: 'travelCategory',
                    attributes: ['id', 'name'],
                },
                {
                    model: tourType,
                    as: 'tourType',
                    attributes: ['id', 'name'],
                },
                {
                    model: destination,
                    as: 'destination',
                    attributes: ['id', 'country_name'],
                },
                {
                    model: PackageMonthModel,
                    // as: 'month',
                    attributes: ['package_id', 'month_id'],
                    include: [
                        {
                            model: MonthModel,
                            // as: 'month',
                            attributes: ['name'],
                        }
                    ]
                },
                {
                    model: PackageFacilitiesModel,
                    as: 'package_facilities',
                    attributes: ['package_id', 'value'],
                    include: [
                        {
                            model: FacilityModel,
                            as: 'facility',
                            attributes: [
                                'name',
                                'image',
                                'description',
                            ],
                        }
                    ]
                },
                // {
                //     model: PackageFacilitiesModel,
                //     // as: 'facilities',
                //     attributes: ['package_id', 'value'],
                //     include: [
                //         {
                //             model: FacilityModel,
                //             // as: 'month',
                //             attributes: ['name',
                //                 "image",
                //                 "description",
                //             ],
                //         }
                //     ]
                // },
                {
                    model: PackageIncludedModel,
                    as: 'includes',
                    attributes: ['id', 'value'],
                },
                {
                    model: PackageExcludedModel,
                    as: 'excludes',
                    attributes: ['id', 'value'],
                },
                {
                    model: PackageItineraryModel,
                    as: 'itineraries',
                    attributes: ['id', 'day', 'title', 'value'],
                },
                // {
                //     model: PackagePointsModel,
                //     as: 'points',
                //     attributes: ['id', 'value'],
                // },

            ],
            order: [['id', 'DESC']],
        });
        if (packages) {
            successResponse(200, 'OK', packages, res);
        }
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.getAllActive = async (req, res) => {
    try {
        const packages = await Package.findAll({
            where: {
                status: 1,
            },
            include: [
                {
                    model: travelCategory,
                    as: 'travelCategory',
                    attributes: ['id', 'name'],
                },
                {
                    model: tourType,
                    as: 'tourType',
                    attributes: ['id', 'name'],
                },
                {
                    model: destination,
                    as: 'destination',
                    attributes: ['id', 'country_name'],
                },
                {
                    model: PackageMonthModel,
                    // as: 'month',
                    attributes: ['package_id', 'month_id'],
                    include: [
                        {
                            model: MonthModel,
                            // as: 'month',
                            attributes: ['name'],
                        }
                    ]
                },
                {
                    model: PackageFacilitiesModel,
                    as: 'package_facilities',
                    attributes: ['package_id', 'value'],
                    include: [
                        {
                            model: FacilityModel,
                            as: 'facility',
                            attributes: [
                                'name',
                                'image',
                                'description',
                            ],
                        }
                    ]
                },
                // {
                //     model: PackageFacilitiesModel,
                //     // as: 'facilities',
                //     attributes: ['package_id', 'value'],
                //     include: [
                //         {
                //             model: FacilityModel,
                //             // as: 'month',
                //             attributes: ['name',
                //                 "image",
                //                 "description",
                //             ],
                //         }
                //     ]
                // },
                {
                    model: PackageIncludedModel,
                    as: 'includes',
                    attributes: ['id', 'value'],
                },
                {
                    model: PackageExcludedModel,
                    as: 'excludes',
                    attributes: ['id', 'value'],
                },
                {
                    model: PackageItineraryModel,
                    as: 'itineraries',
                    attributes: ['id', 'day', 'title', 'value'],
                },
                {
                    model: PackagePointsModel,
                    as: 'points',
                    attributes: ['id', 'value'],
                },
            ],
            order: [['id', 'DESC']],
        });
        if (packages) {
            successResponse(200, 'OK', packages, res);
        }
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.delete = async (req, res) => {
    const { id } = req.params;

    // Delete existing rows before bulk creating new ones
    await bulkDeleteItems(PackageMonthModel, id);
    await bulkDeleteItems(PackageIncludedModel, id);
    await bulkDeleteItems(PackageExcludedModel, id);
    await bulkDeleteItems(PackageItineraryModel, id);
    await bulkDeleteItems(PackagePointsModel, id);
    await bulkDeleteItems(PackageFacilitiesModel, id),
    // await bulkDeleteItemsById(id, models);

    Package.destroy({
        where: { id },
    })
        .then((num) => {
            if (num == 1) {
                PackageFeature.destroy({
                    where: {
                        package_id: id,
                    },
                })
                    .then((num) => {
                        res.send({
                            message: 'Package was deleted successfully!',
                        });
                    })
                    .catch((err) => {
                        res.status(500).send({
                            message: `Could not delete Package with id=${id}`,
                        });
                    });
            } else {
                res.send({
                    message: `Cannot delete Package with id=${id}. Maybe Package was not found!`,
                });
            }
        })
        .catch((err) => {
            res.status(500).send({
                message: `Could not delete Package with id=${id}`,
            });
        });
};

exports.update = async (req, res) => {
    const { id } = req.params;
    const {
        name,
        price,
        package_discount,
        duration,
        tour_month,
        travelCategoryId,
        tourTypeId,
        destination_id,
        min_age,
        description,
        facility,
        highlights_description,
        highlights_bulletpoints,
        included,
        excluded,
        itinerary,
        featured,
        popular,
        status,
    } = req.body;

    const { files } = req;

    console.log("package update*", req.body);

    try {
        const isExist = await Package.findByPk(id);

        if (!isExist) {
            return errorResponse(400, 'ERROR', 'Package Not Found!', res);
        }

        const image = files?.find((file) => file?.fieldname === 'image')?.filename || isExist?.image;

        const updatedPackage = await Package.update(
            {
                name,
                image,
                price,
                package_discount,
                duration,
                tour_month,
                travelCategoryId,
                tourTypeId,
                destination_id,
                min_age,
                description,
                // facility,
                highlights_description,
                highlights_bulletpoints,
                // included,
                // excluded,
                // itinerary,
                featured,
                popular,
                status,
            },
            {
                where: {
                    id,
                },
            }
        );
        console.log("updatedPackage", updatedPackage);

        // if (!updatedPackage.includes(1)) {
        //     return errorResponse(400, 'ERROR', 'Package Update Failed!', res);
        // }

        // await PackageFeature.destroy({
        //     where: {
        //         package_id: id,
        //     },
        // });

        // if (included.length > 0) {
        //     await Promise.all(
        //         included.map(async (feature) => {
        //             await PackageFeature.create({
        //                 package_id: id,
        //                 value: feature.value,
        //             });
        //         })
        //     );
        // }

        // if (features.length > 0) {
        //     await Promise.all(
        //         features.map(async (feature) => {
        //             await PackageFeature.create({
        //                 package_id: id,
        //                 name: feature.name,
        //                 value: feature.value,
        //             });
        //         })
        //     );
        // }

        // const { id } = newPackage;

        if (!updatedPackage.includes(1)) {
            return errorResponse(400, 'ERROR', 'Package Update Failed!', res);
        }

        await PackageFeature.destroy({
            where: {
                package_id: id,
            },
        })



        // Delete existing rows before bulk creating new ones
        await bulkDeleteItems(PackageMonthModel, id);
        await bulkDeleteItems(PackageIncludedModel, id);
        await bulkDeleteItems(PackageExcludedModel, id);
        await bulkDeleteItems(PackageItineraryModel, id);
        await bulkDeleteItems(PackagePointsModel, id);
        await bulkDeleteItems(PackageFacilitiesModel, id),

            // Helper function to handle bulk creation
            // const bulkCreateItems = async (data, model, packageId) => {
            //     const parsedData = JSON.parse(data || '[]');
            //     if (parsedData.length > 0) {
            //         const items = parsedData.map((item) => ({
            //             package_id: packageId,
            //             value: item.value,
            //         }));
            //         console.log(`packageSub parsedData ----->`, parsedData)
            //         const packageSub = await model.bulkCreate(items);
            //         console.log(`packageSub  ----->`, packageSub)
            //     }
            // };



            await bulkCreateMonths(tour_month, PackageMonthModel, id),
            await bulkCreateItems(included, PackageIncludedModel, id),
            await bulkCreateItems(excluded, PackageExcludedModel, id),
            await bulkCreateItineraryItems(itinerary, PackageItineraryModel, id),
            await bulkCreateItems(highlights_bulletpoints, PackagePointsModel, id),
            await bulkCreateItems(facility, PackageFacilitiesModel, id),



            successResponse(200, 'OK', 'Package Updated Successfully!', res);
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Creating Package',
            res
        );
    }
};

exports.getById = async (req, res) => {
    const { id } = req.params;
    try {
        const packageData = await Package.findOne({
            where: {
                id,
            },
            include: [
                {
                    model: travelCategory,
                    as: 'travelCategory',
                    attributes: ['id', 'name'],
                },
                {
                    model: tourType,
                    as: 'tourType',
                    attributes: ['id', 'name'],
                },
                {
                    model: destination,
                    as: 'destination',
                    attributes: ['id', 'country_name'],
                },
                {
                    model: PackageMonthModel,
                    // as: 'month',
                    attributes: ['package_id', 'month_id'],
                    include: [
                        {
                            model: MonthModel,
                            // as: 'month',
                            attributes: ['name'],
                        }
                    ]
                },
                {
                    model: PackageFacilitiesModel,
                    as: 'package_facilities',
                    attributes: ['package_id', 'value'],
                    include: [
                        {
                            model: FacilityModel,
                            as: 'facility',
                            attributes: [
                                'name',
                                'image',
                                'description',
                            ],
                        }
                    ]
                },
                // {
                //     model: PackageFacilitiesModel,
                //     as: 'package_facilities',
                //     attributes: ['package_id', 'value'],
                //     include: [
                //         {
                //             model: FacilityModel,
                //             // as: 'month',
                //             attributes: [
                //                 'name',
                //                 'image',
                //                 'description',
                //             ],
                //         }
                //     ]
                // },
                {
                    model: PackageIncludedModel,
                    as: 'includes',
                    attributes: ['id', 'value'],
                },
                {
                    model: PackageExcludedModel,
                    as: 'excludes',
                    attributes: ['id', 'value'],
                },
                {
                    model: PackageItineraryModel,
                    as: 'itineraries',
                    attributes: ['id', 'day', 'title', 'value'],
                },
                {
                    model: PackagePointsModel,
                    as: 'points',
                    attributes: ['id', 'value'],
                },
            ],
        });
        successResponse(200, 'OK', packageData, res);
    } catch (e) {
        errorResponse(500, 'ERROR', e.message || 'Some error occurred while Creating Package', res);
    }
};

// exports.getPacByCatId = async (req, res) => {
//     const { id } = req.params;
//     try {
//         const packageData = await Package.findAll({
//             where: {
//                 package_cat_id: id,
//             },
//             include: [
//                 {
//                     model: PackageFeature,
//                     order: [['id', 'ASC']],
//                     separate: true,
//                 },
//                 {
//                     model: PackageCategory,
//                     as: 'packageCat',
//                     attributes: ['id', 'name'],
//                 },
//             ],
//             order: [['id', 'DESC']],
//         });
//         successResponse(200, 'OK', packageData, res);
//     } catch (e) {
//         errorResponse(500, 'ERROR', e.message || 'Some error occurred while Creating Package', res);
//     }
// };

exports.searchPackage = async (req, res) => {

    try {
        const packageData = await Package.findAll({
            where: {
                destination_id: req.body?.destination || { [db.Sequelize.Op.ne]: null },
                tourTypeId: req.body?.tour_type || { [db.Sequelize.Op.ne]: null },
                travelCategoryId: req.body?.travel_category || { [db.Sequelize.Op.ne]: null },
                tour_month: req.body?.when || { [db.Sequelize.Op.ne]: null },
            }
        });
        console.log(packageData);
        successResponse(200, 'OK', packageData, res);
    } catch (e) {
        errorResponse(500, 'ERROR', e.message || 'Some error occurred while Creating Package', res);
    }
};


// new update
// exports.update = async (req, res) => {
//     const { id } = req.params;
//     const {
//         name,
//         price,
//         package_discount,
//         duration,
//         travelCategoryId,
//         tourTypeId,
//         min_age,
//         description,
//         facility,
//         highlights_description,
//         highlights_bulletpoints,
//         included,
//         excluded,
//         itinerary,
//         destination_id,
//         status,
//     } = req.body;

//     try {
//         // Check if the package exists
//         const isExist = await Package.findByPk(id);
//         if (!isExist) {
//             return errorResponse(400, 'ERROR', 'Package Not Found!', res);
//         }

//         // Update the main package data
//         const updatedPackage = await Package.update(
//             {
//                 name,
//                 price,
//                 package_discount,
//                 duration,
//                 travelCategoryId,
//                 tourTypeId,
//                 min_age,
//                 description,
//                 facility,
//                 highlights_description,
//                 destination_id,
//                 status,
//             },
//             {
//                 where: { id },
//             }
//         );

//         if (!updatedPackage.includes(1)) {
//             return errorResponse(400, 'ERROR', 'Package Update Failed!', res);
//         }

//         // Cleanup and reinsert `included`
//         if (included) {
//             await PackageIncluded.destroy({ where: { package_id: id } });

//             const parsedIncluded = JSON.parse(included || '[]');
//             if (parsedIncluded.length > 0) {
//                 await Promise.all(
//                     parsedIncluded.map(async (item) => {
//                         await PackageIncluded.create({
//                             package_id: id,
//                             value: item.value,
//                         });
//                     })
//                 );
//             }
//         }

//         // Cleanup and reinsert `excluded`
//         if (excluded) {
//             await PackageExcluded.destroy({ where: { package_id: id } });

//             const parsedExcluded = JSON.parse(excluded || '[]');
//             if (parsedExcluded.length > 0) {
//                 await Promise.all(
//                     parsedExcluded.map(async (item) => {
//                         await PackageExcluded.create({
//                             package_id: id,
//                             value: item.value,
//                         });
//                     })
//                 );
//             }
//         }

//         // Cleanup and reinsert `itinerary`
//         if (itinerary) {
//             await PackageItinerary.destroy({ where: { package_id: id } });

//             const parsedItinerary = JSON.parse(itinerary || '[]');
//             if (parsedItinerary.length > 0) {
//                 await Promise.all(
//                     parsedItinerary.map(async (item) => {
//                         await PackageItinerary.create({
//                             package_id: id,
//                             value: item.value, // Assuming `value` represents the itinerary details
//                         });
//                     })
//                 );
//             }
//         }

//         // Cleanup and reinsert `highlights_bulletpoints`
//         if (highlights_bulletpoints) {
//             await PackagePoints.destroy({ where: { package_id: id } });

//             const parsedHighlights = JSON.parse(highlights_bulletpoints || '[]');
//             if (parsedHighlights.length > 0) {
//                 await Promise.all(
//                     parsedHighlights.map(async (item) => {
//                         await PackagePoints.create({
//                             package_id: id,
//                             value: item.value,
//                         });
//                     })
//                 );
//             }
//         }

//         return successResponse(200, 'OK', 'Package Updated Successfully!', res);
//     } catch (err) {
//         console.error(err);
//         errorResponse(
//             500,
//             'ERROR',
//             err.message || 'Some error occurred while Updating Package',
//             res
//         );
//     }
// };
