const errorResponse = require("../../../../utils/errorResponse");
const successResponse = require("../../../../utils/successResponse");
// const { TeamMembersModel, SocialIconModel } = require(".");
const { model } = require("../../../../config/database.config");

const { team_members: TeamMembersModel, social_icon_list: SocialIconModel } =
  model;

// delete
exports.deleteData = async (req, res) => {
  try {
    const { id } = req.params;

    const result = await TeamMembersModel.destroy({
      where: {
        id,
      },
    });

    if (result !== 1) {
      return errorResponse(
        404,
        "FAILED",
        "Hero section modal deleted failed",
        res,
      );
    }

    await SocialIconModel.destroy({
      where: {
        member_id: id,
      },
    });

    return successResponse(204, "OK", "Hero section deleted successfully", res);
  } catch (err) {
    return errorResponse(500, "ERROR", "There is a server side error", res);
  }
};
