const teamMembersRouter = require("express").Router();
const {
  create,
  getAll,
  getOne,
  getActiveData,
  getActiveSingleData,
  update,
  deleteData,
} = require("../controllers");

module.exports = (app) => {
  teamMembersRouter.post("/", create);

  // get all

  teamMembersRouter.get("/", getAll);

  // get one data

  teamMembersRouter.get("/:id", getOne);

  // get active data

  teamMembersRouter.get("/getData/active", getActiveData);

  // get active single data

  teamMembersRouter.get("/getData/active/:id", getActiveSingleData);

  // update

  teamMembersRouter.put("/:id", update);

  // delete

  teamMembersRouter.delete("/:id", deleteData);

  app.use("/api/team-members", teamMembersRouter);
};
