module.exports = (sequelize, DataTypes) => {
    const visa = sequelize.define('visas', {
        name: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        image: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        price: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        package_discount: {
            type: DataTypes.FLOAT, // it's a percentage (e.g., 10 for 10% discount)
            allowNull: true,
            defaultValue: 0,
        },
        required_documents: {
            type: DataTypes.TEXT,
            allowNull: true ,
        },
        destination_id: {
            type: DataTypes.INTEGER, 
            allowNull: true, // should be false
        },
        visa_mode: {
            type: DataTypes.STRING, // type visa mode
            allowNull: true,
        },
        visa_type_id: {
            type: DataTypes.INTEGER, // shoud be int of visa_type_id
            allowNull: true,
        },
        max_stays: {
            type: DataTypes.INTEGER, // in days
            allowNull: true,
        },
        validity: {
            type: DataTypes.INTEGER, // in days
            allowNull: true,
        },
        success_count: {
            type: DataTypes.INTEGER,
            allowNull: true,
        },
        description: {
            type: DataTypes.TEXT, // Rich Text
            allowNull: true,
        },
        status: {
            type: DataTypes.INTEGER,
            allowNull: true,
            defaultValue: 1,
        },
    });

    return visa;
};
