const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const VisaModel = db.model.visa;

exports.create = async (req, res) => {
    try {

        const { name, destination_id, visa_type, max_stays, validity, visa_mode, price, package_discount, success_count, description, required_documents, visa_faq, status } = req.body;
        const { files } = req;

        const image = files?.find((file) => file?.fieldname === 'image').filename;

        const visaData = {
            name,
            image,
            destination_id,
            visa_type,
            max_stays,
            validity,
            visa_mode,
            price,
            package_discount,
            success_count,
            description,
            required_documents,
            visa_faq,
            status,
        };

        const result = await VisaModel.create(visaData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Visa created failed', res);
        }

        // const { id } = result;

        // // Helper function to handle bulk creation
        // const bulkCreateItemsRequired = async (data, model, visa_id) => {
        //     const parsedData = JSON.parse(data || '[]');
        //     if (parsedData.length > 0) {
        //         const items = parsedData.map((item) => ({
        //             visa_id: visa_id,
        //             value: item.value,
        //         }));
        //         console.log(`packageSub parsedData ----->`, parsedData)
        //         const packageSub = await model.bulkCreate(items);
        //         console.log(`packageSub  ----->`, packageSub)
        //     }
        // };

        // const bulkCreateItemsFAQ = async (data, model, visa_id) => {
        //     const parsedData = JSON.parse(data || '[]');
        //     if (parsedData.length > 0) {
        //         const items = parsedData.map((item) => ({
        //             visa_id: visa_id,
        //             qus: item.qus,
        //             ans: item.ans,
        //         }));
        //         console.log(`packageSub parsedData ----->`, parsedData)
        //         const visa_faq_sub = await model.bulkCreate(items);
        //         console.log(`packageSub  ----->`, visa_faq_sub)
        //     }
        // };

        // await bulkCreateItemsRequired(required_documents, Visa_required_documentsModel, id),
        // await bulkCreateItemsFAQ(visa_faq, VisaFAQModel, id),

            successResponse(201, 'OK', result, res);
        // return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await VisaModel.findAll({
            // include: [
            //     {
            //         model: DestinationModel,
            //         as: 'destination',
            //         attributes: ['id', 'country_name'],
            //     },
            // ]
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await VisaModel.findOne({
            where: {
                id,
            },
            // include: [{
            //     model: DestinationModel, as: 'package',
            // }]
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await VisaModel.findAll({
            where: {
                status: 1,
            },
            // include: [{
            //     model: DestinationModel, as: 'package',
            // }]
        });
        console.log("result", result)

        if (result.length === 0) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server-side error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { name, destination_id, visa_type, max_stays, validity, visa_mode, price, package_discount, success_count, description, required_documents, visa_faq, status } = req.body;
        const { files } = req;

        console.log(req.body);

        const isExist = await VisaModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const image =
            files?.find((file) => file?.fieldname === 'image')?.filename ||
            isExist?.image;

        const visaData = {
            name,
            image,
            destination_id,
            visa_type,
            max_stays,
            validity,
            visa_mode,
            price,
            package_discount,
            success_count,
            description,
            required_documents,
            visa_faq,
            status,
        };

        const result = await VisaModel.update(visaData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Visa created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await VisaModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Visa deleted failed', res);
        }

        return successResponse(204, 'OK', 'Visa deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
