// const path = require('path');
require('dotenv').config();
const express = require('express');
const cors = require('cors');
const cookieParser = require('cookie-parser');
// const AppError = require('./utils/appError');
const errorHandler = require('./utils/errorHandler');
const db = require('./config/database.config');

const { logger, responseTimeMiddleware } = require('./logger');

const app = express();

// initialize http cors
require('./config/cors.config')(app);

// parse requests of content-type - application/json

app.use(
    express.json({
        limit: '50mb',
        verify: (req, res, buf, encoding) => {
            if (req.originalUrl.startsWith('/api/payment/stripe/webhook')) {
                req.rawBody = buf.toString(encoding || 'utf8');
            }
        },
    })
);

// parse requests of content-type - application/x-www-form-urlencoded
app.use(express.urlencoded({ limit: '50mb', extended: false }));

// Use the response time middleware
app.use(responseTimeMiddleware);

// Use the logger middleware
app.use(logger);

//  cookie parser
app.use(cookieParser());

// route level error handler
app.use(errorHandler);

const corsOptions = {
    origin: [
        'http://localhost:3000',
        'http://localhost:8080',
        'http://localhost:3001',
        'http://localhost:4000',
        'https://demo.gotriplimited.com',
        'https://gotriplimited.com',
        'https://admin.gotriplimited.com',

    ], // Specify allowed origin
    credentials: true, // Allow credentials
};

app.use(cors(corsOptions));

app.use(express.static('uploads'));
app.use(express.static('xrayfile'));

// database connectivity
const PORT0 = process.env.SERVER_PORT || 5000;
db.sequelize.sync().then(() => {
    console.log('Database Connected Successfully!!');
    console.log('Running On Port: ', PORT0);

    // comment-out bellow code after first run
    // db.model.systemSetting.create({
    //   id: 1,
    //   website_name: "EDMC",
    //   tag_line: "Syscon Solution Ltd.",
    //   address: "This is address",
    //   mobile: "01XXXXXXX",
    //   logo_image: "logo image location",
    //   fav_image: "favorite image location",
    //   copyright: "2023, Syscon Solution",
    //   created_by: 1,
    //   updated_by: 1
    // })
});

// initialize all custom route
require('./config/route.config')(app);

// app level error handler
// app.all("*", (req, res, next) => {
//   next(new AppError(`The URL ${req.originalUrl} does not exists`, 404));
// });

// app.use(express.static(path.join(__dirname, '/build')));
// app.get('*', (req, res) => {
//    res.sendFile(path.join(__dirname, 'build', 'index.html'));
// });
// set port, listen for requests
const PORT = process.env.SERVER_PORT || 5000;

app.get('/health', (req, res) => {
    res.send(`Server is Running at PORT ${PORT}`);
});

app.listen(PORT, () => {
    console.log(`Server is running at PORT ${PORT}`);
});
