const db = require('../../../config/database.config');

const ProductUnit = db.model.productUnit;
const { Op } = db.DataTypes;

const errorResponse = require('../../../utils/errorResponse');
const successResponse = require('../../../utils/successResponse');

// Create and Save a new Product Unit
exports.create = (req, res) => {
    console.log(req.body);
    // Validate request data
    if (!req.body.product_unit_name) {
        errorResponse(400, 'FAILED', 'Content cannot be displayed', res);
    }

    // Create a Product Unit model object after validating request data
    const data = {
        product_unit_name: req.body.product_unit_name,
        info: req.body.info,
        status: parseInt(req.body.status),
    };

    // call model function for inserting data in database
    ProductUnit.create(data)
        .then((data) => {
            successResponse(201, 'OK', data, res);
        })
        .catch((err) => {
            errorResponse(
                500,
                'ERROR',
                err.message || 'Failed to Register, Please try Again!',
                res
            );
        });
};

// Retrieve all Product Unit from the database.
exports.findAll = (req, res) => {
    ProductUnit.findAll()
        .then((data) => {
            successResponse(200, 'OK', data, res);
        })
        .catch((err) => {
            errorResponse(
                500,
                'ERROR',
                err.message || 'Some error occurred while finding the Product Unit',
                res
            );
        });
};

// Find a single Product Unit with an id
exports.findOne = (req, res) => {
    const { id } = req.params;

    ProductUnit.findOne({ where: { id } })
        .then((data) => {
            if (data) {
                successResponse(200, 'OK', data, res);
            } else {
                errorResponse(
                    404,
                    'ERROR',
                    'Some error occurred while finding the Product Unit',
                    res
                );
            }
        })
        .catch((err) => {
            errorResponse(
                500,
                'ERROR',
                err.message || 'Some error occurred while finding the Product Unit',
                res
            );
        });
};

// Update a Product Unit by the id in the request
exports.update = (req, res) => {
    const { id } = req.params;
    const find = ProductUnit.findOne({ where: { id } });
    const data = {
        product_unit_name: req.body.product_unit_name,
        info: req.body.info,
        status: parseInt(req.body.status),
    };

    if (find) {
        ProductUnit.update(data, { where: { id } })
            .then((data) => {
                successResponse(201, 'OK', 'Update Product Unit Successfully', res);
            })
            .catch((err) => {
                errorResponse(
                    500,
                    'ERROR',
                    err.message || 'Some error occurred while finding the Product Unit',
                    res
                );
            });
    } else {
        errorResponse(404, 'FAILED', 'Product Unit not found', res);
    }
};

// Delete a Product Unit with the specified id in the request
exports.delete = (req, res) => {
    const { id } = req.params;

    ProductUnit.destroy({
        where: { id },
    })
        .then((num) => {
            if (num === 1) {
                successResponse(201, 'OK', 'Delete Successfully', res);
            } else {
                errorResponse(
                    404,
                    'ERROR',
                    'Some error occurred while deleting the Product Unit',
                    res
                );
            }
        })
        .catch((err) => {
            errorResponse(
                500,
                'ERROR',
                err.message || 'Some error occurred while finding the Product Unit',
                res
            );
        });
};

// Delete all  Product Unit from the database.
exports.deleteAll = (req, res) => {
    ProductUnit.destroy({ where: {}, truncate: false })
        .then((data) => {
            successResponse(201, 'OK', 'Delete ALl Successfully', res);
        })
        .catch((err) => {
            errorResponse(
                500,
                'ERROR',
                err.message || 'Some error occurred while Deleting All the Product Unit',
                res
            );
        });
};
