const roleRouter = require('express').Router();
const roleController = require('../controllers/role.controller');

module.exports = (app) => {
  roleRouter.post('/create-role', roleController.create);
  roleRouter.get('/', roleController.findAll);
  roleRouter.get('/role/:id', roleController.findOne);
  roleRouter.put('/role/:id', roleController.update);
  roleRouter.delete('/role/:id', roleController.delete);

  //get active role
  roleRouter.get("/active/findAll", roleController.findActiveRole);

  app.use('/api/roles', roleRouter);
};
