const { verifyToken } = require("../../../middlewares/authJwt");
const settingRouter = require("express").Router();
const settingController = require("../controllers/setting.controller");

const uploadMulter = require("../../../middlewares/uploadLogo");

module.exports = (app) => {
    //update settings
    settingRouter.put("/", verifyToken, uploadMulter, settingController.update);

    // retrive settings properties
    settingRouter.get("/", settingController.getData);

    // get settings data by id
    settingRouter.get("/:id", settingController.getDataById);

    settingRouter.post("/image-upload", uploadMulter, settingController.upload);

    app.use("/api/settings", settingRouter);
};

