const db = require('../../../config/database.config');
const errorResponse = require('../../../utils/errorResponse');
const successResponse = require('../../../utils/successResponse');

const { user: UserModel, user_details: UserDetails } = db.model;

async function getUser(req, res) {
    try {
        const { user } = req;

        // console.log('ser', user);
        // const result = await UserModel.findOne({
        //     where: {
        //         mobile: user.mobile,
        //     },
        // });
        // console.log(result);

        return successResponse(200, 'OK', user, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while finding the User.',
            res
        );
    }
}

async function getUserDetails(req, res) {
    try {
        const { user } = req;

        const result = await UserDetails.findOne({
            where: {
                id: user.id,
            },
        });

        user.user_details = result;

        return successResponse(200, 'OK', user, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while finding the User.',
            res
        );
    }
}

module.exports = {
    getUser,
    getUserDetails,
};
