const userRouter = require('express').Router();
const userController = require('../controllers/user.controller');
const userPhotoUploadMulter = require('../../../middlewares/uploadUserPhoto');
const { verifyToken, verifyUser } = require('../../../middlewares/authJwt');
const asyncFuncHelper = require('../../../utils/asyncFuncHelper');
const getUserWithToken = require('../controllers/getUserWithToken');

module.exports = (app) => {
    userRouter.get(
        '/all-users',
        // verifyJwtToken.verifyToken,
        userController.findAll
    );
    userRouter.get('/all-customers', userController.findAllCustomers);
    userRouter.get('/user/:id', userController.findOne);
    userRouter.get('/birthday-report', userController.findAllByBirthdayRange);
    userRouter.put('/user/:id', userController.update);
    userRouter.delete('/user/:id', userController.delete);
    userRouter.post('/user/upload-image', userPhotoUploadMulter, userController.uploadImage);

    userRouter.get('/role/:id', userController.findAllUsersByRoleId);

    userRouter.get('/website/user/get-user', verifyUser, getUserWithToken.getUser);

    userRouter.get('/website/user/get-user-details', verifyUser, getUserWithToken.getUserDetails);

    app.use('/api/users', userRouter);
};
