const audioSurahRouter = require('express').Router();
const audioSurahController = require('../controllers/audioSurah.controller');
const websiteAudioFile = require('../../../../middlewares/websiteAudioFile');

module.exports = (app) => {
    audioSurahRouter.post('/', websiteAudioFile, audioSurahController.create);

    // get all

    audioSurahRouter.get('/', audioSurahController.getAll);

    // get active all

    audioSurahRouter.get('/active/all', audioSurahController.getAllActive);

    // get one event with id

    audioSurahRouter.get('/:id', audioSurahController.getOne);

    // update

    audioSurahRouter.put('/:id', websiteAudioFile, audioSurahController.update);

    // delete

    audioSurahRouter.delete('/:id', audioSurahController.delete);

    app.use('/api/audio-surah', audioSurahRouter);
};
