const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');
const axios = require('axios');
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');
const { generateCodeAndToken } = require('./generateCodeAndToken');

const db = require('../../../../config/database.config');

const User = db.model.user;
const UserDetails = db.model.user_details;

exports.signup = async (req, res) => {
    console.log(req.body);
    try {
        const { user_details, ...userData } = req.body;
        const { role_id, f_name, mobile, password } = userData;

        if (!role_id && !f_name && !mobile && !password) {
            errorResponse(400, 'FAILED', 'role_id, f_name, mobile and password is required', res);
        }
        const isExist = await User.findOne({ where: { mobile: userData.mobile } });

        if (isExist) {
            return errorResponse(404, 'FAILED', 'User exist with this Phone number ', res);
        }

        const userObjData = {
            role_id: userData.role_id ? userData.role_id : 4,
            f_name: userData.f_name ?? null,
            l_name: userData.l_name ?? null,
            mobile: userData.mobile ?? null,
            password: bcrypt.hashSync(userData.password, 8),
            email: userData.email ?? null,
            date_of_birth: userData.date_of_birth ?? null,
            contact_person: userData.contact_person ?? null,
            nid: userData.nid ? userData.nid : null,
            credit_limit: userData.credit_limit ?? null,
            commission_rate: userData.commission_rate ?? null,
            address_1: userData.address_1 ?? null,
            address_2: userData.address_2 ?? null,
            remarks: userData.remarks ?? null,
            image: userData.image ?? null,
            finger_print: userData.finger_print ?? null,
            status: userData.status,
        };

        // res.send(dataObj)

        const userCreatedData = await User.create(userObjData);
        // console.log(userCreatedData);

        if (!userCreatedData) {
            return errorResponse(404, 'FAILED', 'User Create failed', res);
        }

        const { id } = userCreatedData;

        if (user_details) {
            const userDetailsData = {
                user_id: id,
                spouse_f_name: user_details?.spouse_f_name || null,
                spouse_l_name: user_details?.spouse_l_name || null,
                gender_id: user_details?.gender_id || null,
                marital_status_id: user_details?.marital_status_id || null,
                home_phone: user_details?.home_phone || null,
                work_phone: user_details?.work_phone || null,
                sons: Array.isArray(user_details?.sons)
                    ? user_details?.sons.join(',')
                    : user_details?.sons || null,
                daughters: Array.isArray(user_details?.daughters)
                    ? user_details?.daughters.join(',')
                    : user_details?.daughters || null,
                country_id: user_details?.country_id ?? null,
                state_id: user_details?.state_id ?? null,
                city_id: user_details?.city_id ?? null,
            };
            await UserDetails.create(userDetailsData);
        }

        // const msg = await twilioClient.messages.create({
        //     body: `Your verification code is ${uniqueNumber}`,
        //     from: twilioNumber,
        //     to: '+8801303694937',
        // });

        // console.log(msg);

        const { token, code } = generateCodeAndToken(mobile);

        const message = `Dear ${userCreatedData.f_name}, Your verification code is ${code}`;

        await axios.post(
            `https://api.greenweb.com.bd/api.php?token=${process.env.SMS_API_TOKEN}&to=${mobile}&message=${message}`
        );

        return successResponse(201, 'OK', { user: userCreatedData, token }, res);

        // successResponse(201, 'OK', data, res);
    } catch (err) {
        console.log(err);
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while creating the User.',
            res
        );
    }
};
