const jwt = require('jsonwebtoken');
const bcrypt = require('bcryptjs');
const errorResponse = require('../../../../utils/errorResponse');
const successResponse = require('../../../../utils/successResponse');

const db = require('../../../../config/database.config');

const User = db.model.user;

exports.verifyMobileNumber = async (req, res) => {
    try {
        const { code, token } = req.body;
        console.log(req.body);

        if (!code && !token) {
            return errorResponse(400, 'FAILED', 'Field can not be empty!', res);
        }

        const parsedToken = jwt.verify(token, process.env.JWT_SECRET);
        console.log(parsedToken);
        const { mobile, code: code1 } = parsedToken;
        console.log(mobile);

        const validCode = bcrypt.compareSync(code.toString(), code1);
        console.log(validCode);
        if (!validCode) {
            return errorResponse(400, 'FAILED', 'Invalid Code', res);
        }

        const user = await User.findOne({
            where: { mobile },
            attributes: [
                'id',
                'f_name',
                'l_name',
                'mobile',
                'email',
                'address_1',
                'image',
                'status',
            ],
        });
        if (!user.dataValues) {
            return errorResponse(404, 'NOT FOUND', 'User not found', res);
        }

        const cookieToken = jwt.sign(
            {
                id: user.dataValues.id,
                f_name: user.dataValues.f_name,
                mobile: user.dataValues.mobile,
                email: user.dataValues.email,
            },
            process.env.JWT_SECRET,
            {
                expiresIn: '30d',
            }
        );
        console.log(cookieToken);
        res.setHeader('Access-Control-Allow-Credentials', true);
        // res.setHeader('Access-Control-Allow-Origin', 'http://localhost:3000');
        // res.setHeader('Access-Control-Allow-Headers', true);

        res.cookie('token', cookieToken, {
            httpOnly: true,
            secure: true,
            sameSite: 'None',
        });

        return successResponse(200, 'OK', { user, token: cookieToken }, res);
    } catch (err) {
        return errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while Finding User Mobile',
            res
        );
    }
};
