const db = require("../../../../config/database.config");

const errorResponse = require("../../../../utils/errorResponse");

const successResponse = require("../../../../utils/successResponse");
const {
  getBlogDataWithLimit,
  getAllActiveBlogData,
} = require("./getActiveData");

exports.getAllBlogsByCatId = async (req, res) => {
  try {
    const { cat_id } = req.params;

    const { limit, page } = req.query;

    let result = [];

    if (limit && page) {
      result = await getBlogDataWithLimit(limit, page, cat_id);
    } else {
      result = await getAllActiveBlogData(cat_id);
    }

    return successResponse(200, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err?.message || "There is a server side problem",
      res,
    );
  }
};
