const campeignCatRouter = require('express').Router();
const campeignCatController = require('../controllers/campeignCat.controller');

module.exports = (app) => {
    campeignCatRouter.post('/', campeignCatController.create);

    // get all

    campeignCatRouter.get('/', campeignCatController.getAll);

    // get one campeign with id

    campeignCatRouter.get('/:id', campeignCatController.getOne);

    // get active data

    campeignCatRouter.get('/getData/active', campeignCatController.getActiveData);

    // update

    campeignCatRouter.put('/:id', campeignCatController.update);

    // delete

    campeignCatRouter.delete('/:id', campeignCatController.delete);

    app.use('/api/campeign-category', campeignCatRouter);
};
