const courseRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const courseController = require('../controllers/courses.controller');
const getActiveData = require('../controllers/getActiveData');
const getAllCoursesByCatId = require('../controllers/getAllCourseDataByCatId');
const { verifyToken } = require('../../../../middlewares/authJwt');

module.exports = (app) => {
    courseRouter.post('/', websiteImageUpload, courseController.create);

    // get all

    courseRouter.get('/', courseController.getAll);

    // get one course with id

    courseRouter.get('/:id', verifyToken, courseController.getOne);

    // get active data

    courseRouter.get('/get-courses/active', getActiveData.getActiveData);

    // get course data by category

    courseRouter.get('/active/category/:cat_id', getAllCoursesByCatId.getAllCoursesByCatId);

    // update

    courseRouter.put('/:id', websiteImageUpload, courseController.update);

    // delete

    courseRouter.delete('/:id', courseController.delete);

    app.use('/api/courses', courseRouter);
};
