const eventRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const eventController = require('../controllers/events.controller');
const getActiveEvents = require('../controllers/getActiveEvents');
const getAlleventsByCatId = require('../controllers/getAllEventsByCatId');

module.exports = (app) => {
    eventRouter.post('/', websiteImageUpload, eventController.create);

    // get all

    eventRouter.get('/', eventController.getAll);

    // get one event with id

    eventRouter.get('/:id', eventController.getOne);

    // get active data

    eventRouter.get('/get-events/active', getActiveEvents.getActiveEvent);

    eventRouter.get('/active/latest', getActiveEvents.getLatestActiveEvents);

    // get event data by category

    eventRouter.get('/active/category/:cat_id', getAlleventsByCatId.getAllEventsByCatId);

    // update

    eventRouter.put('/:id', websiteImageUpload, eventController.update);

    // delete

    eventRouter.delete('/:id', eventController.delete);

    app.use('/api/events', eventRouter);
};
