const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const Facility = db.model.facility;

exports.create = async (req, res) => {
    try {
        const { name, description } = req.body;
        const { files } = req;

        // const image = files?.find((file) => file?.fieldname === 'facility_img').filename;
        const image = files?.find((file) => file?.fieldname === 'image').filename;

        const facilityData = {
            name,
            image,
            description,
        };

        const result = await Facility.create(facilityData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Facility created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await Facility.findAll();

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await Facility.findAll({
            where: {
                status: 1,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { name, description } = req.body;
        const { files } = req;

        // console.log(req.body);

        const isExist = await Facility.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const image =
            files?.find((file) => file?.fieldname === 'facility_img')?.filename || isExist?.image;

        const facilityData = {
            name,
            image,
            description,
        };

        const result = await Facility.update(facilityData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Facility created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await Facility.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Facility deleted failed', res);
        }

        return successResponse(204, 'OK', 'Facility deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
