const footerRouter = require('express').Router();
const footerController = require('../controllers/footer.controller');
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');

module.exports = (app) => {
    footerRouter.post('/website/image/upload', websiteImageUpload, footerController.imageUpload);

    footerRouter.post('/', footerController.create);

    // get all the data

    footerRouter.get('/', footerController.getAll);

    // get one data

    footerRouter.get('/:id', footerController.getOne);

    // get active data

    footerRouter.get('/getData/active', footerController.getActiveData);

    // update hero hero-section

    footerRouter.put('/:id', websiteImageUpload, footerController.update);

    // delete hero section
    footerRouter.delete('/:id', footerController.delete);

    app.use('/api/footer', footerRouter);
};
