const heroSectionRouter = require('express').Router();
const heroSectionController = require('../controllers/heroSection.contoller');
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');

module.exports = (app) => {
    heroSectionRouter.post('/', websiteImageUpload, heroSectionController.create);

    // get all the data

    heroSectionRouter.get('/', heroSectionController.getAll);

    // get active data

    heroSectionRouter.get('/active', heroSectionController.getActiveData);

    // update hero hero-section

    heroSectionRouter.put('/:id', websiteImageUpload, heroSectionController.update);

    // delete hero section
    heroSectionRouter.delete('/:id', heroSectionController.delete);

    app.use('/api/hero-section', heroSectionRouter);
};
