const jobRequestRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const jobRequestController = require('../controllers/jobRequest.controller');

module.exports = (app) => {
    jobRequestRouter.post('/', websiteImageUpload, jobRequestController.create);

    // get all the data

    jobRequestRouter.get('/', jobRequestController.getAll);

    // get all job request by id

    jobRequestRouter.get('/jobs/:job_id', jobRequestController.getJobById);

    // find one

    jobRequestRouter.get('/:id', jobRequestController.getOne);

    // update hero hero-section

    jobRequestRouter.put('/:id', websiteImageUpload, jobRequestController.update);

    // delete hero section
    jobRequestRouter.delete('/:id', jobRequestController.delete);

    app.use('/api/job-request', jobRequestRouter);
};
