const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const MediaGalleryModel = db.model.media_gallery;

exports.create = async (req, res) => {
    try {
        const { title, description, associate_group, status, album_id } = req.body;
        console.log(req.files);

        const image = req.files?.find((file) => file?.fieldname === 'image')?.filename;

        const mediaData = {
            title,
            image,
            description,
            associate_group,
            status,
            album_id,
        };

        const result = await MediaGalleryModel.create(mediaData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'media create Failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', err);
    }
};

exports.findAll = async (req, res) => {
    try {
        const { group } = req.query;

        const result = await MediaGalleryModel.findAll({
            where: {
                associate_group: group,
            },
        });

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};

// get One

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await MediaGalleryModel.findOne({
            where: {
                id,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'ABout us section not found with this id ', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(404, 'ERROR', err.message || 'There is a server sid problem', res);
    }
};

exports.findActive = async (req, res) => {
    try {
        const { group } = req.query;
        const result = await MediaGalleryModel.findAll({
            where: {
                associate_group: group,
                status: 1,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', `${group} Data not  found`, res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// update about us

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { title, description, status, associate_group, album_id } = req.body;

        const isExist = await MediaGalleryModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No User found with this id', res);
        }

        const image =
            req.files?.find((file) => file?.fieldname === 'image')?.filename || isExist?.image;

        const mediaData = {
            title,
            image,
            description,
            status,
            associate_group,
            album_id,
        };

        const result = await MediaGalleryModel.update(mediaData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', `${associate_group} update Failed`, res);
        }

        return successResponse(201, 'OK', `${associate_group} update successfully`, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', err);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;
        console.log(id);

        const result = await MediaGalleryModel.destroy({
            where: {
                id,
            },
        });

        console.log(result);

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Media Data delete failed', res);
        }

        return successResponse(204, 'OK', 'Deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side problem', res);
    }
};
