const axios = require('axios');
const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

// dbs

const { mosque_list: MosqueList } = db.model;

async function getSalahTime(masjid_id) {
    try {
        const salahData = await axios.get(
            `https://masjidal.com/api/v1/time/range?masjid_id=${masjid_id}`
        );
        if (salahData.data.status !== 'success') {
            throw new Error('Failed to get salah time');
        }
        return salahData.data.data;
    } catch (err) {
        throw new Error(err);
    }
}

exports.findFirstActiveMosque = async (_, res) => {
    try {
        const mosque = await MosqueList.findOne({
            where: {
                status: 1,
            },
            order: [['order', 'ASC']],
        });

        if (!mosque) {
            return errorResponse(404, 'NOT FOUND', 'mosque not found', res);
        }

        const salahData = await getSalahTime(mosque.masjid_id);

        if (!salahData) {
            return errorResponse(404, 'NOT FOUND', 'Mosque with times not found', res);
        }

        const result = {
            ...mosque.dataValues,
            ...salahData,
        };

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};

exports.findAllActiveMosqueWithTimes = async (_, res) => {
    try {
        const mosqueList = await MosqueList.findAll({
            where: {
                status: 1,
            },
            order: [['order', 'ASC']],
        });

        const result = await Promise.all(
            mosqueList.map(async (mosque) => {
                const salahData = await getSalahTime(mosque.masjid_id);
                return {
                    ...mosque.dataValues,
                    ...salahData,
                };
            })
        );

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};
