const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

// dbs

const { mosque_list: MosqueList } = db.model;

exports.findAll = async (_, res) => {
    try {
        const result = await MosqueList.findAll({
            order: [['order', 'ASC']],
        });
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};

// find one

exports.findOne = async (req, res) => {
    try {
        const result = await MosqueList.findOne({
            where: {
                id: req.params.id,
            },
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'Mosque List not found with this id', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};
