const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

// dbs

const { mosque_list: MosqueList } = db.model;

// update
exports.update = async (req, res) => {
    try {
        const { name, address, masjid_id, order, status } = req.body;

        const { id } = req.params;

        const isExist = await MosqueList.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'Salat times not found with this id', res);
        }

        const result = await MosqueList.update(
            {
                name,
                address,
                order,
                status,
                masjid_id,
            },
            {
                where: {
                    id,
                },
            }
        );

        if (!result.includes(1)) {
            return errorResponse(404, 'NOT FOUND', 'Update Failed. Please check your request', res);
        }

        return successResponse(200, 'OK', 'Salat times updated successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There is a server side error', res);
    }
};
