const mosqueListRouter = require('express').Router();
const mosqueListController = require('../controller/mosqueList.controller');
const create = require('../controller/create');
const update = require('../controller/update');
const deleteMosque = require('../controller/delete');
const mosqueListWithPrayerTimes = require('../controller/findMosqueWithPrayerTimes');

module.exports = (app) => {
    // create
    mosqueListRouter.post('/', create.create);

    // get all
    mosqueListRouter.get('/', mosqueListController.findAll);

    // get one

    mosqueListRouter.get('/:id', mosqueListController.findOne);

    // update

    mosqueListRouter.put('/:id', update.update);

    // delete

    mosqueListRouter.delete('/:id', deleteMosque.delete);

    // get salat time with prayer times

    mosqueListRouter.get('/prayer-times/active', mosqueListWithPrayerTimes.findFirstActiveMosque);

    // get all mosque with salat times

    mosqueListRouter.get(
        '/prayer-times/get-all/active',
        mosqueListWithPrayerTimes.findAllActiveMosqueWithTimes
    );

    app.use('/api/mosque-list', mosqueListRouter);
};
