const ourServiceRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const ourServiceController = require('../controllers/ourService.controller');

module.exports = (app) => {
    ourServiceRouter.post('/', websiteImageUpload, ourServiceController.create);

    // get all

    ourServiceRouter.get('/', ourServiceController.getAll);

    // get active data

    ourServiceRouter.get('/active', ourServiceController.getActiveData);

    // update

    ourServiceRouter.put('/:id', websiteImageUpload, ourServiceController.update);

    // delete

    ourServiceRouter.delete('/:id', ourServiceController.delete);

    app.use('/api/our-service', ourServiceRouter);
};
