// Testing
module.exports = (sequelize, DataTypes) => {
    const Package = sequelize.define('packages', {
        name: {
            type: DataTypes.STRING,
            allowNull: false,
        },
        image: {
            type: DataTypes.STRING,
            // allowNull: false,
        },
        // video_link: {
        //     type: DataTypes.STRING,
        //     // allowNull: false,
        // },
        price: {
            type: DataTypes.STRING,
        },
        package_discount: {
            type: DataTypes.FLOAT, // it's a percentage (e.g., 10 for 10% discount)
            defaultValue: 0,
        },
        duration: {
            type: DataTypes.STRING, // How many days
        },
        tour_month: {
            type: DataTypes.TEXT, 
        },
        travelCategoryId: {
            type: DataTypes.INTEGER,
        },
        tourTypeId: {
            type: DataTypes.INTEGER, // should be an array of ids then DataTypes.JSON
        },
        destination_id: {
            type: DataTypes.INTEGER, // should be destinationId
            // type: DataTypes.TEXT, 
        },
        max_people: {
            type: DataTypes.INTEGER,
            defaultValue: 1,
        },
        min_age: {
            type: DataTypes.INTEGER,
            defaultValue: 0,
        },
        description: {
            type: DataTypes.TEXT,
        },
        highlights_description: {
            type: DataTypes.TEXT,
        },
        // facility: {
        //     type: DataTypes.JSON, // array of facilities
        //     // type: DataTypes.INTEGER, // array of facilityId
        // },
        // highlights_bulletpoints: {
        //     type: DataTypes.TEXT, 
        //     // type: DataTypes.JSON,
        // },
        // included: {
        //     type: DataTypes.TEXT, 
        //     // type: DataTypes.JSON, // array
        // },
        // excluded: {
        //     type: DataTypes.TEXT, 
        //     // type: DataTypes.JSON, // array
        // },
        // itinerary: {
        //     type: DataTypes.JSON, // Stores plans for each day of the tour as a JSON object
        // },
        
        // location: {
        //     type: DataTypes.INTEGER, // should be destinationId
        // },
        featured: {
            type: DataTypes.INTEGER,
            defaultValue: 0,
        },
        popular: {
            type: DataTypes.INTEGER,
            defaultValue: 0,
        },
        status: {
            type: DataTypes.INTEGER,
            defaultValue: 1,
        },
    });

    return Package;
};

/**
CREATE TABLE Packages (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    price VARCHAR(255),
    package_discount FLOAT DEFAULT 0,
    duration VARCHAR(255),
    status INT DEFAULT 1,
    travelCategoryId INT,
    tourTypeId INT,
    min_age INT DEFAULT 0,
    description TEXT,
    facility JSON,
    highlights_description TEXT,
    highlights_bulletpoints JSON,
    included JSON,
    excluded JSON,
    itinerary JSON,
    location INT,
    createdAt DATETIME NOT NULL,
    updatedAt DATETIME NOT NULL
);


*/
