const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const StatCounterModel = db.model.stat_counter;

exports.create = async (req, res) => {
    try {
        const { title, count_number, status } = req.body;
        const { files } = req;
        const icon_img = files?.find((file) => file?.fieldname === 'icon_img')?.filename;
        const counterData = {
            title,
            count_number,
            icon_img,
            status,
        };

        const result = await StatCounterModel.create(counterData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Destination created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await StatCounterModel.findAll();

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await StatCounterModel.findAll({
            where: {
                status: 1,
            },
        });

        // if (!result) {
        //     return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        // }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { files } = req;
        const { title, count_number, status } = req.body;

        const isExist = await StatCounterModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const icon_img =
            files?.find((file) => file?.fieldname === 'icon_img')?.filename || isExist?.icon_img;

        const counterData = {
            title,
            count_number,
            icon_img,
            status,
        };

        const result = await StatCounterModel.update(counterData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Stat Counter created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await StatCounterModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'stat counter deleted failed', res);
        }

        return successResponse(204, 'OK', 'State counter deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
