const stateCounterRouter = require('express').Router();
const StateCounterController = require('../controllers/statCounter.controller');

const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');

module.exports = (app) => {
    stateCounterRouter.post('/', websiteImageUpload, StateCounterController.create);

    // get all

    stateCounterRouter.get('/', StateCounterController.getAll);

    // get active data

    stateCounterRouter.get('/active', StateCounterController.getActiveData);

    // update

    stateCounterRouter.put('/:id', websiteImageUpload, StateCounterController.update);

    // delete

    stateCounterRouter.delete('/:id', StateCounterController.delete);

    app.use('/api/stat-counter', stateCounterRouter);
};
