const errorResponse = require("../../../../utils/errorResponse");
const successResponse = require("../../../../utils/successResponse");
// const { TeamMembersModel, SocialIconModel } = require(".");
const { model } = require("../../../../config/database.config");

const { team_members: TeamMembersModel, social_icon_list: SocialIconModel } =
  model;

exports.create = async (req, res) => {
  try {
    const {
      name,
      title,
      image,
      order_no,
      mobile,
      status,
      iconData,
      email,
      address,
      description,
    } = req.body;

    console.log(req.body);

    const serviceData = {
      name,
      title,
      mobile,
      email,
      address,
      description,
      image,
      order_no,
      status,
    };

    const result = await TeamMembersModel.create(serviceData);

    if (!result) {
      return errorResponse(404, "FAILED", "service created failed", res);
    }

    await Promise.all(
      iconData?.map(async (icon) => {
        SocialIconModel.create({
          title: icon?.title,
          icon: icon?.icon,
          link: icon?.link,
          member_id: result?.id,
        });
      }),
    );

    return successResponse(201, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err?.message || "There is a server side problem",
      res,
    );
  }
};
