const errorResponse = require("../../../../utils/errorResponse");
const successResponse = require("../../../../utils/successResponse");
const { model } = require("../../../../config/database.config");

const { team_members: TeamMembersModel, social_icon_list: SocialIconModel } =
  model;

// const { TeamMembersModel, SocialIconModel } = require("./index");

// get all
exports.getAll = async (_, res) => {
  try {
    console.log(TeamMembersModel);
    const result = await TeamMembersModel.findAll({
      include: [
        {
          model: SocialIconModel,
        },
      ],
      order: [["order_no", "ASC"]],
    });

    return successResponse(200, "OK", result, res);
  } catch (error) {
    return errorResponse(
      500,
      "ERROR",
      error.message || "There is a server side problem",
      res,
    );
  }
};
