const errorResponse = require("../../../../utils/errorResponse");
const successResponse = require("../../../../utils/successResponse");

const { model } = require("../../../../config/database.config");

const { team_members: TeamMembersModel, social_icon_list: SocialIconModel } =
  model;

// update
exports.update = async (req, res) => {
  try {
    const { id } = req.params;
    const isExist = await TeamMembersModel.findOne({
      where: {
        id,
      },
    });

    if (!isExist) {
      return errorResponse(404, "NOT FOUND", "No Data found with this id", res);
    }

    const {
      name,
      title,
      mobile,
      status,
      image,
      order_no,
      iconData,
      email,
      address,
      description,
    } = req.body;

    const serviceData = {
      name,
      title,
      mobile,
      email,
      address,
      description,
      image: image || isExist.image,
      order_no,
      status,
    };

    const result = await TeamMembersModel.update(serviceData, {
      where: {
        id,
      },
    });

    if (!result.includes(1)) {
      return errorResponse(404, "FAILED", "service created failed", res);
    }

    await SocialIconModel.destroy({
      where: {
        member_id: id,
      },
    });

    await Promise.all(
      iconData?.map(async (icon) => {
        SocialIconModel.create({
          title: icon?.title,
          icon: icon?.icon,
          link: icon?.link,
          member_id: isExist?.id,
        });
      }),
    );

    return successResponse(201, "OK", "Update Successfully", res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err?.message || "There is a server side problem",
      res,
    );
  }
};
