const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const travelCategoryModel = db.model.travelCategory;
const PackageModel = db.model.package;


exports.create = async (req, res) => {
    try {
        const { name, success_count, description, status } = req.body;
        const { files } = req;

        const image = files?.find((file) => file?.fieldname === 'image').filename;

        const travelCategoryData = {
            name,
            image,
            success_count,
            description,
            status,
        };

        const result = await travelCategoryModel.create(travelCategoryData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Travel Category created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await travelCategoryModel.findAll({
            include: [
                {
                    model: PackageModel,
                    as: 'package',
                    attributes: ['id', 'name'],
                }
            ],
            order: [['id', 'DESC']],
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await travelCategoryModel.findAll({
            where: {
                status: 1,
            },
            include: [
                {
                    model: PackageModel,
                    as: 'packages',
                    attributes: ['id', 'name'],
                }
            ],
            order: [['id', 'DESC']],
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { name, success_count, description, status } = req.body;
        const { files } = req;

        console.log('travelCategory log =>', req.body);

        const isExist = await travelCategoryModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const image =
            files?.find((file) => file?.fieldname === 'image')?.filename || isExist?.image;

        const travelCategoryData = {
            name,
            image,
            success_count,
            description,
            status,
        };

        const result = await travelCategoryModel.update(travelCategoryData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Travel Category created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await travelCategoryModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Travel Category deleted failed', res);
        }

        return successResponse(204, 'OK', 'Travel Category deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
