const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const VisaTypeModel = db.model.visa_type;

exports.create = async (req, res) => {
    try {

        const { name, status } = req.body;
        // 

        // const image = files?.find((file) => file?.fieldname === 'image').filename;

        const visaData = {
            name, status
        };

        const result = await VisaTypeModel.create(visaData);

        if (!result) {
            return errorResponse(404, 'FAILED', 'Visa Type created failed', res);
        }

        // const { id } = result;

        // // Helper function to handle bulk creation
        // const bulkCreateItemsRequired = async (data, model, visa_id) => {
        //     const parsedData = JSON.parse(data || '[]');
        //     if (parsedData.length > 0) {
        //         const items = parsedData.map((item) => ({
        //             visa_id: visa_id,
        //             value: item.value,
        //         }));
        //         console.log(`packageSub parsedData ----->`, parsedData)
        //         const packageSub = await model.bulkCreate(items);
        //         console.log(`packageSub  ----->`, packageSub)
        //     }
        // };

        // const bulkCreateItemsFAQ = async (data, model, visa_id) => {
        //     const parsedData = JSON.parse(data || '[]');
        //     if (parsedData.length > 0) {
        //         const items = parsedData.map((item) => ({
        //             visa_id: visa_id,
        //             qus: item.qus,
        //             ans: item.ans,
        //         }));
        //         console.log(`packageSub parsedData ----->`, parsedData)
        //         const visa_faq_sub = await model.bulkCreate(items);
        //         console.log(`packageSub  ----->`, visa_faq_sub)
        //     }
        // };

        // await bulkCreateItemsRequired(required_documents, Visa_required_documentsModel, id),
        // await bulkCreateItemsFAQ(visa_faq, VisaFAQModel, id),

            successResponse(201, 'OK', result, res);
        // return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await VisaTypeModel.findAll({
            // include: [
            //     {
            //         model: DestinationModel,
            //         as: 'destination',
            //         attributes: ['id', 'country_name'],
            //     },
            // ]
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await VisaTypeModel.findOne({
            where: {
                id,
            },
            // include: [{
            //     model: DestinationModel, as: 'package',
            // }]
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await VisaTypeModel.findAll({
            where: {
                status: 1,
            },
            // include: [{
            //     model: DestinationModel, as: 'package',
            // }]
        });
        console.log("result", result)

        if (result.length === 0) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }
        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server-side error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { name, status } = req.body;
        

        console.log(req.body);

        const isExist = await VisaTypeModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        // const image =
        //     files?.find((file) => file?.fieldname === 'image')?.filename ||
        //     isExist?.image;

        const visaData = {
            name,
            status
        };

        const result = await VisaTypeModel.update(visaData, {
            where: {
                id,
            },
        });

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Visa Type created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await VisaTypeModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'Visa Type deleted failed', res);
        }

        return successResponse(204, 'OK', 'Visa Type deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
