const visaTypeRouter = require('express').Router();
const websiteImageUpload = require('../../../../middlewares/websiteImageUpload');
const visaTypeController = require('../controller/visa_type.controller');

module.exports = (app) => {
    visaTypeRouter.post('/', visaTypeController.create);

    // get all

    visaTypeRouter.get('/', visaTypeController.getAll);

    // get active data

    visaTypeRouter.get('/active', visaTypeController.getActiveData);

    // get one

    visaTypeRouter.get('/:id', visaTypeController.getOne);

    // update

    visaTypeRouter.put('/:id', websiteImageUpload, visaTypeController.update);

    // delete

    visaTypeRouter.delete('/:id', visaTypeController.delete);

    app.use('/api/visa_type', visaTypeRouter);
};
