const multer = require("multer");
const path = require("path");

const storage = multer.diskStorage({
  destination: function (req, res, cb) {
    cb(null, "./uploads/products/");
  },
  filename: function (req, file, cb) {
    const fileExt = path.extname(file.originalname);
    let fileName = file.originalname
        .replace(fileExt, "")
        .toLowerCase()
        .split(" ")
        .join("-");

    if (fileName.length > 20) {
      fileName = fileName.slice(0, 20);
    }

    fileName += "-" + Date.now();
    cb(null, fileName + fileExt);
  },
});

const fileFilter = (req, res, cb) => {
  cb(null, true);
};

let upload = multer({
  storage: storage,
  fileFilter: fileFilter,
});

module.exports = upload.any();
