require('dotenv').config();
const jwt = require('jsonwebtoken');
const bcrypt = require('bcryptjs');
const db = require('../../../config/database.config');
const errorResponse = require('../../../utils/errorResponse');
const successResponse = require('../../../utils/successResponse');

const User = db.model.user;
const Role = db.model.role;
const RolePermission = db.model.rolePermission;

exports.signin = async (req, res) => {
    try {
        const userData = req.body;
        console.log(userData);

        if (!userData) {
            return errorResponse(400, 'FAILED', 'Content can not be empty!', res);
        }
        const userQuery = await User.findOne({
            where: { email: userData.email },
            include: [
                {
                    model: Role,
                    attributes: ['name', 'info'],
                },
            ],
        });
        if (!userQuery) {
            return res.status(404).send({
                status: '0',
                message: 'Invalid Email Address or Password',
                data: [],
            });
        }
        const passwordIsValid = bcrypt.compareSync(userData.password, userQuery.password);

        if (!passwordIsValid) {
            return res.status(401).send({
                accessToken: null,
                message: 'Invalid Email Address or Password',
            });
        }

        const rolePermissionsQuery = await RolePermission.findAll({
            where: {
                role_id: userQuery.role_id,
            },
            attributes: ['module_id', 'activity_id'],
        });

        if (rolePermissionsQuery) {
            const userQueryData = {
                userQuery,
                permissions: rolePermissionsQuery,
            };

            const expiresIn = userData.rememberMe ? '30d' : '24h'; // 30 days if "Remember Me" is checked, otherwise 24 hours

            const token = jwt.sign({ id: userQuery.id }, process.env.JWT_SECRET, {
                expiresIn,
            });

            res.status(200).send({
                status: '1',
                message: 'You are Successfully Logged in',
                token,
                data: userQueryData,
            });
        }
    } catch (err) {
        errorResponse(
            500,
            'ERROR',
            err.message || 'Some error occurred while creating the User.',
            res
        );
    }
};
