const bcrypt = require('bcryptjs');
const errorResponse = require('../../../utils/errorResponse');
const successResponse = require('../../../utils/successResponse');

const db = require('../../../config/database.config');

const User = db.model.user;

exports.password = async (req, res) => {
    try {
        const { new_password, confirm_password, email } = req.body;

        const isExist = await User.findOne({
            where: {
                email,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'FAILED', 'User not found', res);
        }

        if (new_password === confirm_password) {
            const userUpdate = await User.update(
                {
                    password: bcrypt.hashSync(confirm_password, 10),
                },

                {
                    where: {
                        email,
                    },
                }
            );

            if (!userUpdate.includes(1))
                return errorResponse(404, 'FAILED', 'Password Update Failed', res);
        }
        return successResponse(201, 'OK', 'Password updated Successfully', res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There was a server side problem', res);
    }
};
