// const { user, user_details, country, state, city } =
//     require('../../../config/database.config').model;
/* eslint-disable no-param-reassign */

module.exports = (sequelize, DataTypes) => {
    const UserDetails = sequelize.define(
        'user_details',
        {
            user_id: {
                type: DataTypes.INTEGER,
                allowNull: false,
            },
            father_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            mother_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            gender_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            marital_status_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            spouse_f_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            spouse_l_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            home_phone: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            work_phone: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            sons: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            daughters: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            country_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            state_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            city_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            blood_group: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            owner_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            institution_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            responsible_person_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            designation: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            vehicle_license: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            trade_license: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            bmdc_license: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            dghs_license: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            drug_license: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            online_service_time: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            available_service: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            delivery_person_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            driver_name: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            driving_license: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            last_blood_donate: {
                type: DataTypes.DATEONLY,
                allowNull: true,
            },
            specialization_degree: {
                type: DataTypes.STRING,
                allowNull: true,
            },
            driving_exp_years: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            nationality_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            profession_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            company_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            delegates_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            introducer_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            package_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            package_price: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            paid_amount: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
            payment_method_id: {
                type: DataTypes.INTEGER,
                allowNull: true,
            },
        },
        {
            tableName: 'user_details',
            timestamps: false,
        }
    );

    // const ArrToString = (user) => {
    //     let sonsString = '';
    //     if (Array.isArray(user.sons)) {
    //         sonsString = user.sons.join(',');
    //     }
    //     let daughtersString = '';
    //     if (Array.isArray(user.daughters)) {
    //         daughtersString = user.daughters.join(',');
    //     }
    //     return { sons: sonsString, daughters: daughtersString };
    // };
    //
    // UserDetails.beforeCreate(async (user, options) => {
    //     console.log('before create working');
    //     const { sons, daughters } = ArrToString(user);
    //     user.sons = sons;
    //     user.daughters = daughters;
    // });
    //
    // UserDetails.beforeUpdate(async (user, options) => {
    //     const { sons, daughters } = ArrToString(user);
    //     user.sons = sons;
    //     user.daughters = daughters;
    // });
    //
    const StringToArr = (user) => {
        let sonsArray = [];
        if (user.sons) {
            sonsArray = user.sons.split(',');
        }
        let daughtersArray = [];
        if (user.daughters) {
            daughtersArray = user.daughters.split(',');
        }
        return { sons: sonsArray, daughters: daughtersArray };
    };

    UserDetails.afterFind(async (user, options) => {
        if (Array.isArray(user)) {
            user.forEach((u) => {
                const { sons, daughters } = StringToArr(u);
                u.sons = sons;
                u.daughters = daughters;
            });
        } else {
            const { sons, daughters } = StringToArr(user);
            user.sons = sons;
            user.daughters = daughters;
        }
    });

    return UserDetails;
};
