/* eslint-disable prettier/prettier */
const db = require("../../../../config/database.config");

const errorResponse = require("../../../../utils/errorResponse");

const successResponse = require("../../../../utils/successResponse");

const AboutUsModel = db.model.about_us;

exports.create = async (req, res) => {
  try {
    const { title, description, status, button_title, button_link } = req.body;

    const side_img = req.files?.find(
      (file) => file?.fieldname === "side_img"
    )?.filename;

    const middle_img = req.files?.find(
      (file) => file?.fieldname === "middle_img"
    )?.filename;

    const circle_img = req.files?.find(
      (file) => file?.fieldname === "circle_img"
    )?.filename;

    const aboutUsData = {
      title,
      side_img,
      middle_img,
      circle_img,
      description,
      status,
      button_title,
      button_link,
    };

    const result = await AboutUsModel.create(aboutUsData);

    if (!result) {
      return errorResponse(404, "FAILED", "About us create Failed", res);
    }

    return successResponse(201, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err.message || "There is a server side error",
      err
    );
  }
};

exports.findAll = async (req, res) => {
  try {
    const result = await AboutUsModel.findAll();

    return successResponse(200, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err.message || "There is a server side error",
      res
    );
  }
};

// get One

exports.getOne = async (req, res) => {
  try {
    const { id } = req.params;

    const result = await AboutUsModel.findOne({
      where: {
        id,
      },
    });

    if (!result) {
      return errorResponse(
        404,
        "NOT FOUND",
        "ABout us section not found with this id ",
        res
      );
    }

    return successResponse(200, "OK", result, res);
  } catch (err) {
    return errorResponse(
      404,
      "ERROR",
      err.message || "There is a server sid problem",
      res
    );
  }
};

exports.findActive = async (_, res) => {
  try {
    const result = await AboutUsModel.findOne({
      where: {
        status: 1,
      },
    });

    if (!result) {
      return errorResponse(
        404,
        "NOT FOUND",
        "No Active About Us Data found",
        res
      );
    }

    return successResponse(200, "OK", result, res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err?.message || "There is a server side problem",
      res
    );
  }
};

// update about us

exports.update = async (req, res) => {
  try {
    const { id } = req.params;
    const { title, description, status, button_title, button_link } = req.body;

    const isExist = await AboutUsModel.findOne({
      where: {
        id,
      },
    });

    if (!isExist) {
      return errorResponse(404, "NOT FOUND", "No User found with this id", res);
    }

    const side_img =
      req.files?.find((file) => file?.fieldname === "side_img")?.filename ||
      isExist?.side_img;

    const middle_img =
      req.files?.find((file) => file?.fieldname === "middle_img")?.filename ||
      isExist?.middle_img;

    const circle_img =
      req.files?.find((file) => file?.fieldname === "circle_img")?.filename ||
      isExist?.circle_img;

    const aboutUsData = {
      title,
      side_img,
      middle_img,
      circle_img,
      description,
      status,
      button_title,
      button_link,
    };

    const result = await AboutUsModel.update(aboutUsData, {
      where: {
        id,
      },
    });

    if (!result.includes(1)) {
      return errorResponse(404, "FAILED", "About us update Failed", res);
    }

    return successResponse(201, "OK", "ABout Us update successfully ", res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err.message || "There is a server side error",
      err
    );
  }
};

// delete

exports.delete = async (req, res) => {
  try {
    const { id } = req.params;
    console.log(id);

    const result = await AboutUsModel.destroy({
      where: {
        id,
      },
    });

    console.log(result);

    if (result !== 1) {
      return errorResponse(404, "FAILED", "ABout us delete failed", res);
    }

    return successResponse(204, "OK", "Deleted successfully", res);
  } catch (err) {
    return errorResponse(
      500,
      "ERROR",
      err.message || "There is a server side problem",
      res
    );
  }
};
