const { Op } = require('sequelize');

const db = require('../../../../config/database.config');

const errorResponse = require('../../../../utils/errorResponse');

const successResponse = require('../../../../utils/successResponse');

const AlbumModelModel = db.model.albumVideo;

const VidoModel = db.model.video;

exports.create = async (req, res) => {
    try {
        const { title, info, order, status } = req.body;
        const { files } = req;

        console.log("req.body1", req.body)
        console.log("files1", req)

        const image = files?.find((file) => file?.fieldname === 'image').filename;

        const album = {
            title,
            info,
            order,
            image,
            status,
        };
        console.log("album", album)
        const result = await AlbumModelModel.create(album);
        console.log("album", result)

        if (!result) {
            return errorResponse(404, 'FAILED', 'event category created failed', res);
        }

        return successResponse(201, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// get all

exports.getAll = async (_, res) => {
    try {
        const result = await AlbumModelModel.findAll({
            include: [{
                model: VidoModel, as: 'videos',
            }],
            order: [['order', 'ASC']],
        });

        return successResponse(200, 'OK', result, res);
    } catch (error) {
        return errorResponse(500, 'ERROR', error.message || 'There is a server side problem', res);
    }
};

// get one

exports.getOne = async (req, res) => {
    try {
        const { id } = req.params;
        const result = await AlbumModelModel.findOne({
            where: {
                id,
            },
            include: [{
                model: VidoModel, as: 'videos',
            }],

        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

exports.getActiveData = async (_, res) => {
    try {
        const result = await AlbumModelModel.findAll({
            where: {
                status: 1,
            },
            include: [
                {
                    model: VidoModel,
                    as: 'videos',
                    // required: true,
                },
            ],
        });

        // const data = await Promise.all(
        //     result.map(async (category) => {
        //         const events = await EventModel.findAll({
        //             where: {
        //                 event_cat: {
        //                     [Op.like]: `%${category.id}%`,
        //                 },
        //             },
        //         });
        //
        //         return {
        //             ...category.dataValues,
        //             event_list: events,
        //         };
        //     })
        // );
        //
        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// find all the media gallery by album id

exports.getActiveDataById = async (req, res) => {
    try {
        console.log(req);
        const { id } = req.params;
        console.log(id);
        const result = await AlbumModelModel.findOne({
            where: {
                status: 1,
                id,
            },
            include: [
                {
                    model: VidoModel,
                    as: 'videos',
                    // required: true,
                },
            ],
        });

        if (!result) {
            return errorResponse(404, 'NOT FOUND', 'NO Active data found', res);
        }

        return successResponse(200, 'OK', result, res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err.message || 'There was a server side Error', res);
    }
};

// update

exports.update = async (req, res) => {
    try {
        const { id } = req.params;
        const { title, info, order, status } = req.body;
        const { files } = req;

        console.log("req.body update", req.body)


        const isExist = await AlbumModelModel.findOne({
            where: {
                id,
            },
        });

        if (!isExist) {
            return errorResponse(404, 'NOT FOUND', 'No Data found with this id', res);
        }

        const image =
            files?.find((file) => file?.fieldname === 'image')?.filename ||
            isExist?.image;

        const eventData = {
            title,
            info,
            order,
            image,
            status,
        };
        console.log("album update", eventData)
        const result = await AlbumModelModel.update(eventData, {
            where: {
                id,
            },
        });
        console.log("album result", result)

        if (!result.includes(1)) {
            return errorResponse(404, 'FAILED', 'Album Data created failed', res);
        }

        return successResponse(201, 'OK', 'Update Successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', err?.message || 'There is a server side problem', res);
    }
};

// delete

exports.delete = async (req, res) => {
    try {
        const { id } = req.params;

        const result = await AlbumModelModel.destroy({
            where: {
                id,
            },
        });

        if (result !== 1) {
            return errorResponse(404, 'FAILED', 'album  deleted failed', res);
        }

        return successResponse(204, 'OK', 'Album deleted successfully', res);
    } catch (err) {
        return errorResponse(500, 'ERROR', 'There is a server side error', res);
    }
};
